from rest_framework.serializers import ListField, CharField, ModelSerializer

from cars.carsharing.models import CarsharingTagPhoto
from cars.django.serializers import BaseSerializer, TimestampField


class UploadTagPhotoViewArgumentsSerializer(BaseSerializer):

    content = CharField()
    photo_id = CharField()
    type = CharField()
    tags = ListField(child=CharField())


class ServiceAppTagPhotoSerializer(ModelSerializer):

    submitted_at = TimestampField()

    class Meta:
        model = CarsharingTagPhoto
        fields = '__all__'
