from django.conf.urls import url

from . import views


app_name = 'service_app'
urlpatterns = [
    # Car information endpoints
    url(r'^car-models/', views.CarModelsView.as_view(), name='car-models'),

    # Assembly endpoints, car creation
    url(
        r'^assembly/car/create/$',
        views.CarCreateByVINView.as_view(),
        name='car-create-by-vin',
    ),  # proxied
    url(
        r'^cars/(?P<car_id>[\w-]+)/picker/$',
        views.CarSetResponsiblePicker.as_view(),
        name='car-set-responsible-picker',
    ),  # proxied

    # Assembly
    url(
        r'^assembly/sim/upload/$',
        views.UploadCarHardwareSimView.as_view(),
        name='car-assembly-sim-upload',
    ),  # proxied
    url(
        r'^assembly/beacon/upload/$',
        views.UploadCarHardwareBeaconView.as_view(),
        name='car-assembly-beacon-upload',
    ),  # proxied
    url(
        r'^assembly/vega/upload/$',
        views.UploadCarHardwareVegaView.as_view(),
        name='car-assembly-vega-upload',
    ),  # proxied

    url(
        r'^cars/(?P<car_id>[\w-]+)/attached-devices/$',
        views.CarAttachedDevicesView.as_view(),
        name='car-attached-devices',
    ),  # proxied

    url(
        r'^cars/(?P<car_id>[\w-]+)/change-vin/$',
        views.CarChangeVINView.as_view(),
        name='car-change-vin',
    ),

    url(
        r'^cars/(?P<car_id>[\w-]+)/attach-device/$',
        views.CarHardwareAttachToCarView.as_view(),
        name='car-attach-device',
    ),  # proxied
]
