import logging

from django.shortcuts import get_object_or_404
from rest_framework.exceptions import PermissionDenied

from cars.django.views import CarsharingAPIView
from cars.users.models import User


LOGGER = logging.getLogger(__name__)


class ServiceAppAPIView(CarsharingAPIView):

    view_action = None

    def __init__(self, **kwargs):
        super().__init__(**kwargs)
        self.requester_user = None

    def initial(self, request, *args, **kwargs):
        super().initial(request, *args, **kwargs)
        self.requester_user = request.user
        requester_is_supervisor = True
        if 'user_id' in request.GET:
            self.requester_user = get_object_or_404(User, id=request.GET['user_id'])
        if not requester_is_supervisor:
            self._verify_role(self.requester_user)
            self._verify_access_permission(self.requester_user, *args, **kwargs)

    def _verify_role(self, user):
        if not self.role_manager.has_role_from_list(user, self.authorized_roles):
            raise PermissionDenied

    def _verify_access_permission(self, user, *args, **kwargs):  # pylint: disable=unused-argument
        access_manager = self.role_manager.get_access_manager(user)
        if not access_manager.is_access_permitted(self.view_action, kwargs.get('car_id')):
            raise PermissionDenied
