from rest_framework.mixins import ListModelMixin

from cars.carsharing.models import CarModel
from cars.drive.serializers.carsharing import CarModelSerializer
from .base import ServiceAppAPIView


class CarModelsView(ListModelMixin, ServiceAppAPIView):  # should be completely identical to the one in /drive

    serializer_class = CarModelSerializer


    def get_queryset(self):
        return CarModel.objects.all()

    def do_get(self, request, *args, **kwargs):
        return self.list(request, *args, **kwargs)
