import base64

from django.shortcuts import get_object_or_404
from rest_framework.exceptions import ParseError
from rest_framework.response import Response

from cars.carsharing.core.tag_photo_manager import TagPhotoManager
from cars.carsharing.models import Car, CarsharingTagPhoto
from ..serializers.tag_photo import ServiceAppTagPhotoSerializer, UploadTagPhotoViewArgumentsSerializer
from .base import ServiceAppAPIView


class BaseTagPhotoView(ServiceAppAPIView):

    def _get_required_param(self, request, param):
        value = request.GET.get(param)
        if value is None:
            raise ParseError

        return value


class UploadTagPhotoView(BaseTagPhotoView):

    arguments_serializer_class = UploadTagPhotoViewArgumentsSerializer

    def do_post(self, request, *args, **kwargs):  # pylint:disable=unused-argument
        car = get_object_or_404(Car, id=kwargs['car_id'])
        tags = request.arguments['tags']
        type_ = request.arguments['type']
        photo_id = request.arguments['photo_id']
        content_b64 = request.arguments['content']

        manager = TagPhotoManager.from_settings(
            user=self.requester_user,
            car=car,
        )

        photo = manager.upload_photo(
            photo_content=base64.b64decode(content_b64.encode('utf-8')),
            photo_id=photo_id,
            type_=type_,
            tags=tags,
        )

        return Response(ServiceAppTagPhotoSerializer(photo, many=True).data)


class TagPhotosView(BaseTagPhotoView):

    def do_get(self, request, *args, **kwargs):  # pylint:disable=unused-argument
        tag_id = self._get_required_param(request, 'tag_id')
        photos = CarsharingTagPhoto.objects.filter(tag_id=tag_id)

        return Response(
            ServiceAppTagPhotoSerializer(photos, many=True).data
        )
