import importlib
import os


def import_wildcard(module):
    '''Import all public names from the module to the global scope.'''
    target_scope = globals()
    for name in dir(module):
        if name.startswith('_'):
            continue
        target_scope[name] = getattr(module, name)


SETTINGS_MODULE_NAME = os.environ.get('CARS_SETTINGS_MODULE', 'cars.settings.dev')
SETTINGS_MODULE = importlib.import_module(SETTINGS_MODULE_NAME)
import_wildcard(SETTINGS_MODULE)
