import os
from .utils import set_secret_default


set_secret_default('CARSHARING_ANIMALS_TOKEN',            'CARSHARING_ANIMALS_TOKEN',            '')
set_secret_default('CARSHARING_ANIMALS_TOKEN',            'CARSHARING_ANIMALS_TOKEN_LOGIN',      '')
set_secret_default('CARSHARING_FRONTEND_TVM2_SECRET',     'CARSHARING_FRONTEND_TVM2_SECRET',     '')
set_secret_default('CARSHARING_AUDIOTELE_AUTH_TOKEN',     'CARSHARING_AUDIOTELE_AUTH_TOKEN',     '')
set_secret_default('CARSHARING_AUDIOTELE_BASIC_AUTH_PASSWORD', 'CARSHARING_AUDIOTELE_BASIC_AUTH_PASSWORD', '')
set_secret_default('CARSHARING_AUDIOTELE_FTP_PASSWORD',   'CARSHARING_AUDIOTELE_FTP_PASSWORD',   '')
set_secret_default('CARSHARING_AUDIOTELE_TRACKS_AES_KEY', 'CARSHARING_AUDIOTELE_TRACKS_AES_KEY', '0' * 32)
set_secret_default('CARSHARING_AUDIOTELE_TOKEN_SALT',     'CARSHARING_AUDIOTELE_TOKEN_SALT',     '')
set_secret_default('CARSHARING_AUTO_TAGS_TOKEN',          'CARSHARING_AUTO_TAGS_TOKEN',          '')
set_secret_default('CARSHARING_AUTOCODE_SECRET_ID',       'CARSHARING_AUTOCODE_SECRET_ID',       '')
set_secret_default('CARSHARING_AUTOCODE_SECRET_ID',       'CARSHARING_YNDX_FINES_TOKEN',           '')
set_secret_default('CARSHARING_BEEPER_FTP_PASSWORD',      'CARSHARING_BEEPER_FTP_PASSWORD',      '')
set_secret_default('CARSHARING_BEEPER_TRACKS_AES_KEY',    'CARSHARING_BEEPER_TRACKS_AES_KEY', '0' * 32)
set_secret_default('CARSHARING_BLACKBOX_TVM2_SECRET',     'CARSHARING_BLACKBOX_TVM2_SECRET',     '')
set_secret_default('CARSHARING_CALLCENTER_MDS_ACCESS_KEY_ID', 'CARSHARING_CALLCENTER_MDS_ACCESS_KEY_ID', '')
set_secret_default('CARSHARING_CALLCENTER_MDS_SECRET_ACCESS_KEY', 'CARSHARING_CALLCENTER_MDS_SECRET_ACCESS_KEY', '')
set_secret_default('CARSHARING_CALLCENTER_SECRET_KEY',    'CARSHARING_CALLCENTER_SECRET_KEY',    '')
set_secret_default('CARSHARING_CHAT2DESK_API_TOKEN',      'CARSHARING_CHAT2DESK_API_TOKEN',      '')
set_secret_default('CARSHARING_CHAT2DESK_AUTH_TOKEN',     'CARSHARING_CHAT2DESK_AUTH_TOKEN',     '')
set_secret_default('CARSHARING_DEPTRANS_TOKEN',           'CARSHARING_DEPTRANS_TOKEN',           '')
set_secret_default('CARSHARING_DOCS_AES_KEY',             'CARSHARING_DOCS_AES_KEY',       '0' * 64)
set_secret_default('CARSHARING_DOCS_HASHES_KEY',          'CARSHARING_DOCS_HASHES_KEY',    '0' * 32)
set_secret_default('CARSHARING_EKA_PASSWORD',             'CARSHARING_EKA_PASSWORD',             '')
set_secret_default('CARSHARING_MDS_ACCESS_KEY_ID',        'CARSHARING_MDS_ACCESS_KEY_ID',        '')
set_secret_default('CARSHARING_MDS_SECRET_ACCESS_KEY',    'CARSHARING_MDS_SECRET_ACCESS_KEY',    '')
set_secret_default('CARSHARING_OCTOPUS_API_KEY',          'CARSHARING_OCTOPUS_API_KEY',          '')
set_secret_default('CARSHARING_ROBOT_CARSHARING_TOKEN',   'CARSHARING_ROBOT_CARSHARING_TOKEN',   '')
set_secret_default('CARSHARING_ROBOT_DRV_REQ_TOKEN',      'CARSHARING_ROBOT_DRV_REQ_TOKEN',      '')
set_secret_default('CARSHARING_SENDER_TOKEN',             'CARSHARING_SENDER_TOKEN',             '')
set_secret_default('CARSHARING_SOCIAL_TVM2_SECRET',       'CARSHARING_SOCIAL_TVM2_SECRET',       '')
set_secret_default('CARSHARING_STAFF_TOKEN',              'CARSHARING_STAFF_TOKEN',              '')
set_secret_default('CARSHARING_STARTREK_TOKEN',           'CARSHARING_STARTREK_TOKEN',           '')
set_secret_default('CARSHARING_TOLOKA_TOKEN',             'CARSHARING_TOLOKA_TOKEN',             '')
set_secret_default('CARSHARING_TRUST_SERVICE_TOKEN',      'CARSHARING_TRUST_SERVICE_TOKEN',      '')
set_secret_default('CARSHARING_TVM2_SECRET',              'CARSHARING_TVM2_SECRET',              '')
set_secret_default('CARSHARING_XIVA_SEND_TOKEN',          'CARSHARING_XIVA_SEND_TOKEN',          '')
set_secret_default('CARSHARING_XIVA_SUBSCRIPTION_TOKEN',  'CARSHARING_XIVA_SUBSCRIPTION_TOKEN',  '')
set_secret_default('CARSHARING_YANG_ROBOT_OAUTH_TOKEN',   'CARSHARING_YANG_ROBOT_OAUTH_TOKEN',   '')
set_secret_default('CARSHARING_YQL_TOKEN',                'CARSHARING_YQL_TOKEN',                '')
set_secret_default('CARSHARING_YT_TOKEN',                 'CARSHARING_YT_TOKEN',                 '')
set_secret_default('CARS_DB_QA_PASSWORD',                 'CARS_DB_QA_PASSWORD',                 '')

from .base import *  # pylint: disable=wildcard-import,unused-wildcard-import,wrong-import-position


USER = os.environ.get('USER', 'anonymous')


ADMIN['acl'] = None


CALCULATOR['client']['verify_ssl'] = False


DB = {
    'default': {
        'host': os.environ.get('CARSHARING_DEV_DB_HOST', 'zpd-01.search.yandex.net'),
        'port': 5432,
        'name': 'carsharing_dev_{}'.format(USER),
        'user': USER,
        'password': USER,
    },
}


DJANGO_DEBUG = True


DJANGO_AUTHENTICATION_BACKENDS = [
    'django.contrib.auth.backends.ModelBackend',
    # Disable BlackBox auth at all
    # 'django_yauth.authentication_mechanisms.cookie.Mechanism',
    # 'django_yauth.authentication_mechanisms.oauth.Mechanism',
]


DRIVE['early_access']['enabled'] = False


LOGGING['loggers']['']['level'] = 'DEBUG'
LOGGING['loggers']['django.db.backends'] = {
    'level': 'DEBUG',
    'handlers': ['console'],
    'propagate': False,
}
LOGGING['loggers']['parso.python.diff'] = {  # IPython autocomplete logger.
    'level': 'INFO',
    'propagate': True,
}


MDS['verify_ssl'] = False


OCTOPUS['verify_ssl'] = False


PASSPORT['verify_ssl'] = False


PEDESTRIAN_ROUTER['SAAS_CONFIG']['service_name'] = 'default-router'


REGISTRATION_YANG['verifier']['class'] = \
    'cars.registration_yang.core.verifier.YangSecretIdVerifierStub'


TELEMATICS['proxy_class'] = 'cars.carsharing.core.telematics_proxy.TelematicsProxyStub'


TRUST['verify_ssl'] = False


YASMS['client_class'] = 'unittest.mock.MagicMock'


ZOOKEEPER['workdir'] = '/cars/dev/alerts'
