import copy

from cars.aggregator.static_data import clients, operators
from cars.core.constants import AppPlatform
from .base import *  # pylint: disable=wildcard-import,unused-wildcard-import


ADMIN['porsche']['user_role'] = 'porsche_admin'


BLACKBOX['url'] = 'https://blackbox.yandex.net/blackbox'
BLACKBOX['url_external'] = 'https://blackbox.yandex.net/blackbox'


CALCULATOR['client']['root_url'] = (
    'https://carsharing-calculator.n.yandex-team.ru/api/calculator/v1/'
)


CALLCENTER['acl'] = {
    235842166,  # zxqfd555@yandex.ru
    248152061,  # dd2.0@yandex.ru

    592686701,  # drive-callcenter-testing@yandex.ru

    581410101,  # eugene.jukov@yandex.ru
    581410622,  # pisarev.aleksandar@yandex.ru
    581412327,  # romashkin.vyacheslav@yandex.ru
    599996320,  # oxana.tychenyuk@yandex.ru
    600719957,  # maiya.valkovskaya@yandex.ru
    600771355,  # elina.nosalskaya@yandex.ru
    602580293,  # werafilatowa@yandex.ru
    602586368,  # leontjev.sergiy@yandex.ru
    602914909,  # morgunova.marine@yandex.ru
    603025339,  # mehovasvetlana@yandex.ru
    603027941,  # larica.arbuzova@yandex.ru
    603068143,  # aleksandar.hromenko@yandex.ru
    603446011,  # karina.manenkova@yandex.ru
    603750458,  # tanya.czvetkova@yandex.ru
    603798450,  # aleksandar.fomencko@yandex.ru
    603800618,  # david.copaliani@yandex.ru
    607443604,  # daniil.bobyl@yandex.ru
    605611201,  # nicita.vybornov@yandex.ru
    608809814,  # aleksej.vodolagin@yandex.ru
    608812410,  # jana.shpilevaya@yandex.ru
    608813380,  # pop0va.masha@yandex.ru
    610644646,  # aleksey.va5iliev@yandex.ru
    610645620,  # potapov.aleksij@yandex.ru
    610646112,  # darivorobjewa@yandex.ru
    610646614,  # anastasia.kandala@yandex.ru
    612408592,  # iwanowa.swet1@yandex.ru
    613681875,  # kristinakavunova@yandex.ru
    616186050,  # aksenowa.olha
    616190939,  # elena.shuvaewa@yandex.ru
    642211436,  # amir.gurin
    642212404,  # zvezdina.anastacia
    642212907,  # iulia.mak4rowa
    642213429,  # gorelovairyna
    642224544,  # olga5olovjewa
    642227330,  # natalie.borzova
    642227636,  # ekaterina.ilyunina
    642228166,  # tyutina.5wetlana
    642228483,  # marina.savelj3va
    642229020,  # albincka.karimova
    642229355,  # karpaeva.natalya

    # New portion of operators, added on July 9, 2018
    659521048,
    655238872,
    655239500,
    655240321,
    671370458,
    671371093,
}

CALLCENTER['api']['client_class'] = 'cars.core.telephony.SourceRoutingTelephonyApiHelper'

CALLCENTER['api']['get_settings_url'] = '/mod.cipt-admin/api/routing/applications/get/{application_source}/CONTENT'
CALLCENTER['api']['set_settings_url'] = '/mod.cipt-admin/api/routing/applications/update/{application_source}/CONTENT'

CALLCENTER['call_registration_server_uid'] = 592573770  # drive-callcenter
CALLCENTER['default_performer_id'] = 'ec65f4f0-8fa8-4887-bfdc-ca01c9906696'  # robot-carsharing

CALLCENTER['call_events_url'] = 'https://prestable.carsharing.yandex.net/api/support_staff/call_event'

CALLCENTER['distribute_apps'] = {
    'msk': 'CARSH_MSK_DIST',
    'spb': 'CARSH_SPB_DIST',
    'kzn': 'CARSH_KZN_DIST',
    'sochi': 'CARSH_SCH_DIST',
}

CALLCENTER_INTERNAL['acl'] = {
    # Operators
    9237451,  # Beata1978@yandex.ru
    21334020,  # chevstasy@yandex.ru
    38194648,  # Demonicada@yandex.ru
    42622286,  # pazhitei@yandex.ru
    51853602,  # golubinann@yandex.ru
    54102480,  # nad-kulueva@yandex.ru
    59750513,  # viksem89@yandex.ru
    67246946,  # breaker55@yandex.ru
    77847987,  # Anaxristoforova@yandex.ru
    84122995,  # t.taschkowa@yandex.ru
    84559630,  # zehir.91@yandex.ru
    94632459,  # anhema@yandex.ru
    104749114,  # antipinadarya@yandex.ru
    105913457,  # Dedyanina.anka@yandex.ru
    128015295,  # sakovich.ea@yandex.ru
    130860066,  # lolasommer@yandex.ru
    146085152,  # krasnoshekova.regina@yandex.ru
    150191253,  # juliakomarova2012@yandex.ru
    157647220,  # Wtf4ek@yandex.ru
    161141452,  # al-farabi05@yandex.ru
    174549684,  # ya5693210@yandex.ru
    183387069,  # pchelnickova.natasha@yandex.ru
    239412326,  # rockjopdjaz@yandex.ru
    253523891,  # marikona2014@yandex.ru
    301378136,  # kirpimary@yandex.ru
    319674899,  # meddeli@yandex.ru
    330570880,  # zapretcod@yandex.ru
    367723564,  # hartunova.mari@yandex.ru
    413093918,  # burjurger1@yandex.ru
    434440592,  # KatherineDann37@yandex.ru
    441620865,  # fedorov.dv7@yandex.ru
    467313590,  # miss.moon-kiss@yandex.ru
    484473795,  # nesterenko.evgeny2018@yandex.ru
    545000503,  # nikolov.j@yandex.ru
    550815083,  # ritabalyas@yandex.ru
    560668495,  # ekaterina.velikaja49@yandex.ru
    551777364,  # maluhina.el@yandex.ru
    592440075,  # zinchenkoanechka@yandex.ru
    593407394,  # ksanitabiz@yandex.ru
    593449668,  # alena.v.nikiforova@yandex.ru
    594601137,  # fatyanovaantonina@yandex.ru
    595136081,  # k5usha1618@yandex.ru
    595340426,  # tinoid73@yandex.ru
    595861989,  # anngst@yandex.ru
    597325774,  # m.matyushkova@yandex.ru
    597666256,  # ponomargal@yandex.ru
    598649417,  # elena.valuiskova@yandex.ru
    600457927,  # sh1ndand@yandex.ru
    602581541,  # tatyanasushentseva@yandex.ru
    603951663,  # AlexandrStrogy@yandex.ru
    604830458,  # yuliasilchenko@yandex.ru
    604816566,  # rogoza.lada@yandex.ru
    606677051,  # katuha2809@yandex.ru
    609127335,  # boychenkoov@yandex.ru
    612184142,  # g-maltzeva2@yandex.ru
    636140314,  # schkirinka@yandex.ru
    644603238,  # nkunakovskaya@yandex.ru

    # Yandex.Drive team
    14113065,  # dbarbashin
    43300445,  # taran-ms
    50680745,  # todiane
    86063197,  # deep-core
    122159482,  # a.rznv
    164421795,  # bergusman
    204286059,  # yndx.raspopova
    235842166,  # zxqfd555
    248152061,  # dd2.0
    287808946,  # malish.kukush (@kosolapova)
    311753795,  # S.kovalev3
    401077842,  # therabbitinspace
    438352826,  # a.a.semchenko
    569008069,  # vlvlgoal
    571443797,  # fleethead

    # Test-user
    602773516,  # internal-cc-test
}


CAR_INDEX['SAAS_CONFIG'] = {
    'index_host': 'saas-indexerproxy-maps.yandex.net',
    'search_host': 'saas-searchproxy-maps.yandex.net:17000',
    'key': 'd948371d599fb543eaae1c83a3e3e2df',
    'service_name': 'car_sharing_app',
    'timeout': 1,
}


CARSHARING['acceptance']['images_access_host'] = (
    'https://carsharing-acceptances.s3.yandex.net'
)


COMMON['default_performer_id'] = 'ec65f4f0-8fa8-4887-bfdc-ca01c9906696'  # robot-carsharing


DB = {
    'default': {
        'host': 'c-cf93d9c8-2f19-4fdc-a986-87c75712e029.rw.db.yandex.net',
        'port': '6432',
        'name': 'extmaps-carsharing-production',
        'user': 'carsharing',
        'password': get_secret('CARS_DB_DEFAULT_PASSWORD', 'CARS_DB_DEFAULT_PASSWORD'),
    },
}

DB_RO_ID = 'ro'
DB_CC_ID = 'support'

DB[DB_RO_ID] = copy.deepcopy(DB['default'])
DB[DB_RO_ID]['host'] = 'c-cf93d9c8-2f19-4fdc-a986-87c75712e029.ro.db.yandex.net'

DB[DB_CC_ID] = {
    'host': 'c-mdbn1lro8vp0a216ccqg.rw.db.yandex.net',
    'port': '6432',
    'name': 'carsharing-support-production',
    'user': 'carsharing',
    'password': None,
}


DEPTRANS['acl'] = {
    612942285,  # deptrans-rnis-production2
}


EKA['robot_user_id'] = 'ec65f4f0-8fa8-4887-bfdc-ca01c9906696'  # robot-carsharing


GEOCODER['url'] = 'http://geocode.maps.yandex.net/1.x/'


FEATURES['banned_operators'][clients.AGGREGATOR] = {
    operators.BELKA_MSK,
    operators.DELIMOBIL_UFA,
    operators.EASYRIDE_MSK,
    operators.YOUDRIVE_MSK,
    operators.YOUDRIVE_SPB,
}
FEATURES['banned_operators'][clients.AGGREGATOR_BETA] = {
    operators.YOUDRIVE_MSK,
    operators.YOUDRIVE_SPB,
}
FEATURES['banned_operators'][clients.AGGREGATOR_PLUS] = {
    operators.EASYRIDE_MSK,
    operators.YOUDRIVE_MSK,
    operators.YOUDRIVE_SPB,
}
FEATURES['banned_operators'][clients.TRANSPORT] = {
    operators.CARENDA_MSK,
    operators.DELIMOBIL_UFA,
    operators.EASYRIDE_MSK,
    operators.URENTCAR_ANAPA,
    operators.URENTCAR_CMW,
    operators.URENTCAR_KRASNODAR,
    operators.URENTCAR_NOVOROSSIYSK,
    operators.URENTCAR_SOCHI,
    operators.YOUDRIVE_MSK,
    operators.YOUDRIVE_SPB,
}
FEATURES['scheme_only_delimobil_for_transport'] = False


FEEDS['solomon']['cluster'] = 'carsharing_prod'

FINES['export_table'] = '//home/carsharing/support/fines/export_ext'
FINES['send_email'] = True
FINES['send_push'] = True
FINES['send_sms'] = False
FINES['charge_limit'] = 2500
FINES['charge_time_limit'] = datetime.timedelta(days=30*3)
FINES['mds']['images_access_host'] = 'https://carsharing-violations.s3.yandex.net/'

# LOGGING['handlers']['sentry'] = {
#     'level': 'WARNING',
#     'class': 'raven.handlers.logging.SentryHandler',
#     'dsn': 'http://eed9414dc5d34f0c94c63d9c44c0ca07:4f9b9769b16744c095e8648a896e80e4@sentry.tools.yandex.net/414',  # pylint: disable=line-too-long
# }
# LOGGING['handlers']['sentry_telematics'] = {
#     'level': 'WARNING',
#     'class': 'raven.handlers.logging.SentryHandler',
#     'dsn': 'http://3939aa1b21084c259ea74b7ad174ac91:771d8532f67c4076a9f7e2bcbbfffde7@sentry.tools.yandex.net/642',  # pylint: disable=line-too-long
# }
# LOGGING['loggers']['']['handlers'].append('sentry')
# LOGGING['loggers']['cars.telematics']['handlers'].append('sentry_telematics')


INCIDENT['evacuation']['ticket_queue'] = {
    'Москва': {'queue': 'DRIVEEVACUATION', 'extra': {'components': ['Москва']}, },
    'Московская область': {'queue': 'DRIVEEVACUATION', 'extra': {'components': ['Московская область']}, },
    'Питер': {'queue': 'SPBEVACUATION', 'extra': {'components': ['Питер']}, },
    'Ленинградская область': {'queue': 'SPBEVACUATION', 'extra': {'components': ['Ленинградская область']}, },
    'Казань': {'queue': 'DRIVEEVACUATION', 'extra': {'components': ['Казань']}, },
}

INCIDENT['evacuation']['template_name'] = {
    'Москва': 'MOSCOW_MAIL_TEXT_DESCRIPTION_TEMPLATE',
    'Московская область': 'MOSCOW_DISTRICT_MAIL_TEXT_DESCRIPTION_TEMPLATE',
    'Питер': 'SPB_MAIL_TEXT_DESCRIPTION_TEMPLATE',
    'Ленинградская область': 'SPB_DISTRICT_MAIL_TEXT_DESCRIPTION_TEMPLATE',
    'Казань': 'KZN_MAIL_TEXT_DESCRIPTION_TEMPLATE',
}

INCIDENT['default_performer_id'] = 'ec65f4f0-8fa8-4887-bfdc-ca01c9906696'  # robot-carsharing
INCIDENT['extra_performer_id'] = 'ab8a237c-2022-4578-a18e-0f554decb22f'  # robot-drv-req

MDS['endpoint_url'] = 'https://s3.mds.yandex.net'

NEW_BILLING['author_user_id'] = 'ec65f4f0-8fa8-4887-bfdc-ca01c9906696'  # robot-carsharing
NEW_BILLING['client_class'] = 'cars.core.new_billing.NewBillingClient'
NEW_BILLING['link_card_url'] = 'https://stable.carsharing.yandex.net/api/yandex/card/'

OCTOPUS['verify_ssl'] = False


ORDERS['export']['path'] = '//home/carsharing/production/orders_tmp'


PASSPORT['url'] = 'https://passport-internal.yandex.ru'


PEDESTRIAN_ROUTER['SAAS_CONFIG']['search_host'] = 'saas-searchproxy-maps.yandex.net:17000'


REFUEL['acl'] = {
    593269211,  # toplivovbak-testing
}

REFUEL['photo_recognition']['toloka_project_id'] = 14509
REFUEL['photo_recognition']['toloka_template_pool_id'] = 2140564


REQUEST_AGGREGATOR['common']['default_performer_id'] = 'ec65f4f0-8fa8-4887-bfdc-ca01c9906696'  # robot-carsharing
REQUEST_AGGREGATOR['beeper']['mds_connection']['file_access_host'] = (
    'https://carsharing-support-beeper.s3.mds.yandex.net/'
)
REQUEST_AGGREGATOR['audiotele']['mds_connection']['file_access_host'] = (
    'https://carsharing-support-audiotele.s3.mds.yandex.net/'
)

REQUEST_AGGREGATOR['callcenter']['export']['operators']['table'] = (
    '//home/carsharing/support/callcenter_operators/export'
)
REQUEST_AGGREGATOR['callcenter']['export']['support_user_available_info']['table'] = (
    '//home/carsharing/support/support_user_available_info/export'
)
REQUEST_AGGREGATOR['callcenter']['export']['roles']['excluded_roles_table'] = (
    '//home/carsharing/support/user_roles/export'
)
REQUEST_AGGREGATOR['callcenter']['export']['roles']['included_roles_table'] = (
    '//home/carsharing/testing/user_roles/export'
)

REQUEST_AGGREGATOR['chat2desk']['export_table'] = (
    '//home/carsharing/support/chat2desk/chats/export'
)

REQUEST_AGGREGATOR['monitoring']['export']['table'] = (
    '//home/carsharing/support/monitoring/export'
)
REQUEST_AGGREGATOR['tags']['export']['common_table'] = (
    '//home/carsharing/support/request_tags/export'
)
REQUEST_AGGREGATOR['tags']['export']['cc_internal_carsharing_table'] = (
    '//home/carsharing/support/request_tags/cc_internal_carsharing_export'
)
REQUEST_AGGREGATOR['tags']['export']['cc_internal_carsharing_vip_table'] = (
    '//home/carsharing/support/request_tags/cc_internal_carsharing_vip_export'
)
REQUEST_AGGREGATOR['tags']['export']['cc_internal_altay_outgoing_table'] = (
    '//home/carsharing/support/request_tags/cc_internal_altay_outgoing_export'
)
REQUEST_AGGREGATOR['tags']['export']['cc_audiotele_incoming_table'] = (
    '//home/carsharing/support/request_tags/cc_audiotele_incoming_export'
)
REQUEST_AGGREGATOR['tags']['export']['cc_audiotele_outgoing_table'] = (
    '//home/carsharing/support/request_tags/cc_audiotele_outgoing_export'
)

REQUEST_AGGREGATOR['call_data']['export']['cc_internal_incoming_table'] = (
    '//home/carsharing/support/call_data/cc_internal_incoming_export'
)
REQUEST_AGGREGATOR['call_data']['export']['cc_internal_outgoing_table'] = (
    '//home/carsharing/support/call_data/cc_internal_outgoing_export'
)
REQUEST_AGGREGATOR['call_data']['export']['cc_internal_routing_table'] = (
    '//home/carsharing/support/call_data/cc_internal_routing_export'
)
REQUEST_AGGREGATOR['call_data']['export']['cc_audiotele_table'] = (
    '//home/carsharing/support/call_data/cc_audiotele_export'
)
REQUEST_AGGREGATOR['call_data']['export']['cc_audiotele_track_table'] = (
    '//home/carsharing/support/call_data/cc_audiotele_track_export'
)

REGISTRATION['taxi_cashback']['phones_table_path'] = \
    '//home/extdata/carsharing/production/promo/registration-taxi-cashback/registered-users'


REGISTRATION_YANG['yt_tables'] = {
    'assignments': '//home/extdata/carsharing/production/yang/requests',
    'results': '//home/extdata/carsharing/production/yang/results',
    'results_archive': '//home/extdata/carsharing/production/yang/results_archive',
}

SAAS_DRIVE['url'] = 'https://admin.carsharing.yandex.net'
SAAS_DRIVE['prestable'] = True  # No /offer_info in production yet.

SEND_PUSH['mds']['file_access_host'] = 'https://carsharing-push-reports.s3.yandex.net/'
SEND_PUSH['reporter']['client_class'] = 'cars.admin.core.send_push_manager.PushResultReporter'

SENDER['url_template'] = ('https://sender.yandex-team.ru/api/0/yandex.carshare/'
                          'transactional/{campaign}/send')

SENTRY['feeds'] = ('http://e6cda11c503943bf8c829fa19c828c06:ef46453296b340bf811cbd1b3dbf0c48'
                   '@sentry.tools.yandex.net/454')


SEGMENTS['premium']['tag'] = 'premium_user_tester'
SEGMENTS['tags_for_models'] = {
    'porsche_macan': 'premium_user_tester',
    'porsche_carrera': 'premium_user_tester',
}


SERVICE_APP['assembly']['photos']['images_access_host'] = (
    'https://carsharing-assembly.s3.yandex.net'
)
SERVICE_APP['tags']['photos']['images_access_host'] = (
    'https://carsharing-tags.s3.yandex.net'
)


SOLOMON['cluster'] = 'production'

STARTREK['api_url'] = 'https://st-api.yandex-team.ru'
STARTREK['web_url'] = 'https://st.yandex-team.ru'

TELEMATICS['packet_handlers']['signal_collector']['url'] = (
    'https://carsharing.n.yandex.ru/api/admin/v1/telematics/signals/'
)
TELEMATICS['packet_handlers']['saas_submission']['status_cache']['get_state_url'] = (
    'https://carsharing.n.yandex.ru/api/admin/v1/car-info-by-imei/status/'
)
TELEMATICS['packet_handlers']['saas_submission']['ride_cache']['get_state_url'] = (
    'https://carsharing.n.yandex.ru/api/admin/v1/car-info-by-imei/ride/'
)


THIRD_PARTY_APIS['renaissance']['endpoint_url'] = (
    'http://services.renins.com/Carsharing/SaveTrip'
)

TOLOKA['url'] = 'https://toloka.yandex.ru'

TRUST['root_url'] = 'https://trust-payments.paysys.yandex.net:8028'
TRUST['back_url'] = 'https://carsharing.yandex-team.ru/api/billing/v1/trust/notify/'


USERS['documents']['datasync']['host'] = 'http://intapi.disk.yandex.net:8080'
USERS['documents']['datasync']['tvm2']['source'] = 2000185
USERS['documents']['datasync']['tvm2']['destination'] = 132
USERS['export_table'] = '//home/extdata/carsharing/production/users/export'
USERS['fast_export_table'] = '//home/extdata/carsharing/production/users/fast_export'


XIVA['url'] = 'https://push.yandex.ru'
XIVA[AppPlatform.IOS]['app_name'] = 'ru.yandex.mobile.drive'


YASMS['url'] = 'http://sms.passport.yandex.ru'


YT['data']['base_dir'] = '//home/extdata/carsharing/production'
YT['locks']['base_dir'] = '//home/extmaps/carsharing/production'


ZOOKEEPER['workdir'] = '/cars/production/alerts'


SOCIAL['consumer'] = 'carsharing'
SOCIAL['url'] = 'https://api.social.yandex.ru'
SOCIAL['tvm2']['source'] = 2000615
SOCIAL['tvm2']['destination'] = 2000382


EXPORT['tmp_path'] = '//home/carsharing/production/data/user/_tmp'
EXPORT['temp_path'] = '//home/carsharing/production/temp'
EXPORT['locks_config']['base_dir'] = '//home/carsharing/production'
EXPORT['home_directory'] = '//home/carsharing/production'
EXPORT['users_table_part'] = '//home/carsharing/production/data/user/_parts/users_table'
EXPORT['orders_table_part'] = '//home/carsharing/production/data/user/_parts/orders_table'
EXPORT['bonus_account_table_part'] = '//home/carsharing/production/data/user/_parts/bonus_account_table'
EXPORT['autocode_fine_table_part'] = '//home/carsharing/production/data/user/_parts/autocode_fine_table'
EXPORT['billing_tasks_table_part'] = '//home/carsharing/production/data/user/_parts/billing_tasks_table'
EXPORT['datasync_part'] = '//home/carsharing/production/data/user/_parts/datasync'
EXPORT['security_part'] = '//home/carsharing/production/data/user/_parts/security'
EXPORT['user_profiles_part'] = '//home/carsharing/production/data/user/_parts/user_profiles'
EXPORT['users_apps_part'] = '//home/carsharing/production/data/user/_parts/users_apps'
EXPORT['users_crypta_part'] = '//home/carsharing/production/data/user/_parts/users_crypta'
EXPORT['users_crypta_profiles_part'] = '//home/carsharing/production/data/user/_parts/users_crypta_profiles'
EXPORT['current_score_part'] = '//home/carsharing/production/data/user/_parts/current_score'
EXPORT['plus_subscribers_part'] = '//home/carsharing/production/data/user/_parts/plus_subscribers'
EXPORT['license_loss_part'] = '//home/carsharing/production/data/user/_parts/license_loss'
EXPORT['plus_part'] = '//home/carsharing/production/data/user/_parts/plus'
EXPORT['bin_attr_part'] = '//home/carsharing/production/data/user/_parts/bin_attr'
EXPORT['users_bin_attr_part'] = '//home/carsharing/production/data/user/_parts/users_bin_attr'
EXPORT['users_table'] = '//home/carsharing/production/data/user/user_attributes'
EXPORT['orders_table'] = '//home/carsharing/production/data/orders'
EXPORT['table_refund_issues_history'] = '//home/carsharing/production/database/refund_issues_history'
