from .production import *  # pylint: disable=wildcard-import,unused-wildcard-import

# admin production may use both internal and external production blackboxes
#   (e.g. to identify real plus users), however tvm access is granted to external production only
# check access grants here: https://grantushka.yandex-team.ru/grants/consumer/

BLACKBOX['url'] = 'https://blackbox.yandex-team.ru/blackbox'
BLACKBOX['url_external'] = 'https://blackbox.yandex.net/blackbox'  # real accounts

BLACKBOX['tvm']['source'] = 2010010  # admin api app
BLACKBOX['tvm']['secret'] = get_secret('CARSHARING_BLACKBOX_TVM2_SECRET', 'CARSHARING_BLACKBOX_TVM2_SECRET')
# BLACKBOX['tvm']['destination'] = 223  # internal production blackbox; update grants to access it

CALLCENTER_INTERNAL['acl'] = None

DJANGO_AUTHENTICATION_BACKENDS = [
    'cars.core.authorization.auth_mechanism.Mechanism',
    'django.contrib.auth.backends.ModelBackend',
    # Disable BlackBox auth at all
    # 'django_yauth.authentication_mechanisms.cookie.Mechanism',
    # 'django_yauth.authentication_mechanisms.oauth.Mechanism',
]

YAUTH_MECHANISMS = [
    'cars.core.authorization.auth_mechanism',
    # Disable BlackBox auth at all
    # 'django_yauth.authentication_mechanisms.cookie',
    # 'django_yauth.authentication_mechanisms.oauth',
]

# temporary: until user actions list merge
SAAS_DRIVE['url'] = 'https://admin.carsharing.yandex.net'
