# -*- coding: utf-8 -*-

import os
import sys
import logging


_logger = logging.getLogger(__name__)


_secret_defaults = {}


# DANGER! You can not load secrets from YT operations
def get_secret(secret_name, key_name, _memo_dict={}):
    # DJANGO_SETTINGS_MODULE set to None, if we are running on YT
    if os.environ.get('DJANGO_SETTINGS_MODULE') is None:
        return None
    key_pair = (secret_name, key_name)
    if key_pair not in _memo_dict:
        file_path = os.path.join(secret_name, key_name)
        if os.path.exists(file_path):
            with open(file_path, 'r') as fd:
                _memo_dict[key_pair] = fd.read().strip()
        else:
            if key_pair not in _secret_defaults:
                _logger.error('Secret "{}/{}" is not set'.format(*key_pair))
                sys.exit(1)
            _memo_dict[key_pair] = _secret_defaults[key_pair]
    return _memo_dict[key_pair]


# DANGER! You can not load secrets from YT operations
def get_hex_secret(secret_name, key_name):
    # DJANGO_SETTINGS_MODULE set to None, if we are running on YT
    if os.environ.get('DJANGO_SETTINGS_MODULE') is None:
        return None
    return bytes.fromhex(get_secret(secret_name, key_name))


# Set default values for secrets, if you do not want to use them
def set_secret_default(secret_name, key_name, value):
    _secret_defaults[(secret_name, key_name)] = value
