
import cars.settings
from cars.core.pusher import Pusher

from .codes import CodeManager
from .client import TaxiClient
from .push_client import TaxiPushClientLogger


class TaxiApi(object):

    def __init__(self):
        self._code_manager = CodeManager()
        self._pusher = Pusher()
        self._push_client = TaxiPushClientLogger(
            filename=cars.settings.PUSH_CLIENT['taxi']['filename'],
        )
        self._client = TaxiClient(
            push_client=self._push_client,
            **cars.settings.TAXI['corp_client']
        )

    def send_validation_code(self, platform, device_id):
        code = self._code_manager.generate(device_id)
        self._pusher.send(
            platform=platform,
            token=device_id,
            message=code,
        )

    def validate_code(self, device_id, code):
        return self._code_manager.validate(device_id, code)

    def make_order(self, platform, device_id, src_point, dst_point):
        order_id = self._client.make_order(src_point, dst_point)
        order = self._client.get_order(order_id)

        message = 'ID заказа: {}\nОт: {}\nДо: {}\n{}'.format(
            order.id,
            order.source.fullname,
            order.destination.fullname,
            order.status.description,
        )

        self._pusher.send(
            platform=platform,
            token=device_id,
            message=message,
        )

        return order_id
