import os

import furl


class TaxiClientUrls(object):

    def __init__(self, base_url, client_id):
        self._client_id = client_id

        base = furl.furl(base_url)

        client_path = os.path.join('api', '1.0', 'client', self._client_id)
        self._client_prefix = base.set(path=client_path)

    @property
    def client_prefix(self):
        return self._client_prefix.copy()

    def get_order_url(self, order_id=None):
        parts = ['order']
        if order_id is not None:
            parts.append(order_id)
        path = os.path.join(*parts)
        url = self.client_prefix.add(path=path).url
        return url

    def get_order_processing_url(self, order_id):
        path = os.path.join('order', order_id, 'processing')
        url = self.client_prefix.add(path=path).url
        return url
