import hashlib


class CodeManager(object):

    CODE_LENGTH = 4
    SALT = 'YANDEX-42'

    def generate(self, client_id):
        salted = client_id + self.SALT
        salted_bytes = salted.encode('utf-8')
        md5 = hashlib.md5(salted_bytes).hexdigest()
        code = md5[:self.CODE_LENGTH].upper()
        return code

    def validate(self, client_id, code):
        true_code = self.generate(client_id)
        return code.lower() == true_code.lower()
