from .base import BasePacketHandler


class LoggerPacketHandler(BasePacketHandler):
    """Log packet data to LogBroker"""

    def __init__(self, *args, push_client, **kwargs):
        super().__init__(*args, **kwargs)
        self._push_client = push_client

    @classmethod
    def get_handler_id(cls):
        return 'logger'

    def handle_packet(self, imei, packet):
        self._log_packet(imei, packet)

    def _log_packet(self, imei, packet):
        packet_type = packet.get_type()
        packet_data = packet.to_dict()
        self._push_client.log(imei=imei, type_=packet_type, data=packet_data)
