import logging

from saaspy import SaasDocument

from .base import BaseSaasSubmitterPacketHandler


LOGGER = logging.getLogger(__name__)


class SaasDriveCarSubmitterPacketHandler(BaseSaasSubmitterPacketHandler):

    @classmethod
    def get_handler_id(cls):
        return 'saas_drive_car'

    @classmethod
    def from_settings(cls):
        return cls(
            saas_client=cls.create_saas_drive_client(),
        )

    def _form_saas_document(self, id_, lat, lon, status, timestamp):
        # According to https://st.yandex-team.ru/DRIVEBACK-14#1515150644000
        doc = SaasDocument(id_)

        doc.add_geodata(
            'geo',
            {
                'type': 'DRIVE_CAR',
                'coordinates': [
                    {
                        'X': lon,
                        'Y': lat,
                    },
                ],
            },
        )
        doc.modification_timestamp = int(timestamp)

        doc.add_property(
            'Status',
            status,
        )

        return doc

    def _handle_subrecord(self, imei, position_subrecord, custom_parameters_subrecord, timestamp):
        saas_document = self._form_saas_document(
            id_=self.status_cache.get_id(imei),
            lat=position_subrecord.lat,
            lon=position_subrecord.lon,
            status=self.status_cache.get_status(imei),
            timestamp=timestamp,
        )

        self._client.modify_document(saas_document, realtime=True)
