import logging

from saaspy import SaasClient

import cars.settings
from .base import BaseSaasSubmitterPacketHandler


LOGGER = logging.getLogger(__name__)


class SaasDriveNavigatorBaseRidingSubmitterPacketHandler(BaseSaasSubmitterPacketHandler):

    saas_config_section = None

    @classmethod
    def get_handler_id(cls):
        raise NotImplementedError

    @classmethod
    def from_settings(cls):
        general_config = cars.settings.TELEMATICS['packet_handlers']['saas_submission']

        saas_config = general_config[cls.saas_config_section]
        saas_client = SaasClient(
            index_host=saas_config['index_host'],
            search_host=None,
            service_name=saas_config['service_name'],
            key=saas_config['key'],
            timeout=saas_config['timeout'],
        )

        return cls(
            saas_client=saas_client,
        )

    def _handle_subrecord(self, imei, position_subrecord, custom_parameters_subrecord, timestamp):
        self._handle_saas_car_riding_subrecord(
            imei=imei,
            position_subrecord=position_subrecord,
            custom_parameters_subrecord=custom_parameters_subrecord,
            timestamp=timestamp
        )


class SaasDriveNavigatorPrestableRidingSubmitterPacketHandler(SaasDriveNavigatorBaseRidingSubmitterPacketHandler):  # pylint: disable=line-too-long

    saas_config_section = 'drive_navigator_service_prestable'

    @classmethod
    def get_handler_id(cls):
        return 'saas_drive_car_prestable'


class SaasDriveNavigatorStableRidingSubmitterPacketHandler(SaasDriveNavigatorBaseRidingSubmitterPacketHandler):  # pylint: disable=line-too-long

    saas_config_section = 'drive_navigator_service_stable'

    @classmethod
    def get_handler_id(cls):
        return 'saas_drive_car_stable'
