import logging

from .base import BaseSaasSubmitterPacketHandler


LOGGER = logging.getLogger(__name__)


class SaasDriveRidingSubmitterPacketHandler(BaseSaasSubmitterPacketHandler):

    @classmethod
    def get_handler_id(cls):
        return 'saas_drive_riding'

    @classmethod
    def from_settings(cls):
        return cls(
            saas_client=cls.create_saas_drive_client(),
        )

    def _handle_subrecord(self, imei, position_subrecord, custom_parameters_subrecord, timestamp):
        self._handle_saas_car_riding_subrecord(
            imei=imei,
            position_subrecord=position_subrecord,
            custom_parameters_subrecord=custom_parameters_subrecord,
            timestamp=timestamp
        )
