import logging

from twisted.internet import defer
from twisted.internet.endpoints import TCP6ServerEndpoint


LOGGER = logging.getLogger(__name__)


class TelematicsBackendServerRunner(object):

    def run(self):
        raise NotImplementedError

    def stop(self):
        raise NotImplementedError


class TCP6TelematicsBackendServerRunner(TelematicsBackendServerRunner):

    def __init__(self, reactor, port, factory):
        self._reactor = reactor
        self._port_number = port
        self._port = None  # twisted.internet.tcp.Port instance.
        self._factory = factory

    @defer.inlineCallbacks
    def run(self):
        endpoint = TCP6ServerEndpoint(self._reactor, self._port_number)
        self._port = yield endpoint.listen(self._factory)
        LOGGER.info('backend server is running on port %s', self._port_number)

    @defer.inlineCallbacks
    def stop(self):
        yield self._port.loseConnection()
