from ..generic_packet import WialonCombinePacketType
from .data import WialonCombineDataPacket
from .keep_alive import WialonCombineKeepAlivePacket
from .login import WialonCombineLoginPacket


class WialonCombinePacketFactory(object):

    @classmethod
    def from_generic_packet(cls, generic_packet):
        type_ = generic_packet.type
        if type_ is WialonCombinePacketType.LOGIN:
            packet_class = WialonCombineLoginPacket
        elif type_ is WialonCombinePacketType.DATA:
            packet_class = WialonCombineDataPacket
        elif type_ is WialonCombinePacketType.KEEP_ALIVE:
            packet_class = WialonCombineKeepAlivePacket
        else:
            # Should not happen.
            # Invalid types are handled on generic packet parsing stage.
            raise RuntimeError('Uknown packet type: {}'.format(type_))

        packet = packet_class.from_generic_packet(generic_packet)

        return packet
