import logging

from .base import BaseCommand, CommandResult


LOGGER = logging.getLogger(__name__)


class OpenDoorsCommand(BaseCommand):

    def __init__(self, *args, id_=None, **kwargs):
        if id_ is None:
            id_ = self._generate_id()
        super().__init__(*args, id_=id_, text='can_openalldoor', **kwargs)

    def _handle_specific_reply(self, text):
        status = None
        code = None
        if text == 'doors unlock done':
            status = CommandResult.Status.OK
        elif text.startswith('break'):
            LOGGER.warning('unknown can_openalldoor break: %s', repr(text))
            status = CommandResult.Status.ERROR
            code = 'unknown'

        if status is not None:
            result = CommandResult(
                status=status,
                code=code,
            )
            self._set_result(result)


class CloseDoorsCommand(BaseCommand):

    def __init__(self, *args, id_=None, **kwargs):
        if id_ is None:
            id_ = self._generate_id()
        super().__init__(*args, id_=id_, text='can_closealldoor', **kwargs)

    def _handle_specific_reply(self, text):
        status = None
        code = None
        if text == 'doors lock done':
            status = CommandResult.Status.OK
        elif text.startswith('break'):
            LOGGER.warning('unknown can_closealldoor break: %s', repr(text))
            status = CommandResult.Status.ERROR
            code = 'unknown'

        if status is not None:
            result = CommandResult(
                status=status,
                code=code,
            )
            self._set_result(result)
