import logging

from .base import BaseCommand, CommandResult


LOGGER = logging.getLogger(__name__)


class EndOfLeaseCommand(BaseCommand):

    _ERROR_REPLIES = {
        'break, driver door is open': 'driver_door_open',
        'break, pass door is open': 'pass_door_open',
        'break, left rear door is open': 'left_rear_door_open',
        'break, right rear door is open': 'right_rear_door_open',
        'break, hood door is open': 'hood_door_open',
        'break, trunk door is open': 'trunk_door_open',
        'break, wrong key position': 'ignition_on',
        'break, wrong selector position': 'selector_not_parking',
        'break, light is on': 'beam_on',
        'break, engine is on': 'engine_on',
    }

    def __init__(self, *args, id_=None, **kwargs):
        if id_ is None:
            id_ = self._generate_id()
        super().__init__(*args, id_=id_, text='yadrive_end_of_lease', **kwargs)

    def _handle_specific_reply(self, text):
        status = None
        code = None
        if text == 'end of lease done':
            status = CommandResult.Status.OK
        elif text in self._ERROR_REPLIES:
            status = CommandResult.Status.ERROR
            code = self._ERROR_REPLIES[text]
        elif text.startswith('break'):
            LOGGER.warning('unknown end_of_lease break: %s', repr(text))
            status = CommandResult.Status.ERROR
            code = 'unknown'

        if status is not None:
            result = CommandResult(
                status=status,
                code=code,
            )
            self._set_result(result)
