import logging

from .base import BaseCommand, CommandResult


LOGGER = logging.getLogger(__name__)


class LockHoodCommand(BaseCommand):

    def __init__(self, *args, id_=None, **kwargs):
        if id_ is None:
            id_ = self._generate_id()
        super().__init__(*args, id_=id_, text='yadrive_hood_lock', **kwargs)

    def _handle_specific_reply(self, text):
        status = None
        code = None
        if text == 'hood lock done':
            status = CommandResult.Status.OK
        elif text.startswith('break'):
            LOGGER.warning('unknown hood_lock break: %s', repr(text))
            status = CommandResult.Status.ERROR
            code = 'unknown'

        if status is not None:
            result = CommandResult(
                status=status,
                code=code,
            )
            self._set_result(result)


class UnlockHoodCommand(BaseCommand):

    def __init__(self, *args, id_=None, **kwargs):
        if id_ is None:
            id_ = self._generate_id()
        super().__init__(*args, id_=id_, text='yadrive_hood_unlock', **kwargs)

    def _handle_specific_reply(self, text):
        status = None
        code = None
        if text == 'hood unlock done':
            status = CommandResult.Status.OK
        elif text.startswith('break'):
            LOGGER.warning('unknown hood_unlock break: %s', repr(text))
            status = CommandResult.Status.ERROR
            code = 'unknown'

        if status is not None:
            result = CommandResult(
                status=status,
                code=code,
            )
            self._set_result(result)
