import collections
import time

from ..solomon import SOLOMON


class CommandRegistry(object):

    class AlreadyRegisteredError(Exception):
        pass

    def __init__(self, eviction_timeout=120):
        self._registry = {}
        self._history = collections.deque()
        self._eviction_timeout = eviction_timeout

    def __len__(self):
        return len(self._registry)

    def register(self, command):
        SOLOMON.set_value('command_registry.registry.size', len(self._registry))
        SOLOMON.set_value('command_registry.history.size', len(self._history))

        self._evict_old_commands()

        assert command.id

        if command.id in self._registry:
            raise self.AlreadyRegisteredError

        self._history.append(command)
        self._registry[command.id] = command

    def get(self, command_id):
        return self._registry.get(command_id)

    def _evict_old_commands(self):
        while self._history:
            if time.time() - self._history[0].issued_at > self._eviction_timeout:
                command = self._history.popleft()
                self._registry.pop(command.id)
            else:
                break
