import logging

from .base import BaseCommand, CommandResult


LOGGER = logging.getLogger(__name__)


class StartOfLeaseCommand(BaseCommand):

    def __init__(self, *args, id_=None, **kwargs):
        if id_ is None:
            id_ = self._generate_id()
        super().__init__(*args, id_=id_, text='yadrive_start_of_lease', **kwargs)

    def _handle_specific_reply(self, text):
        status = None
        code = None
        if text == 'start of lease done':
            status = CommandResult.Status.OK
        elif text.startswith('break'):
            LOGGER.warning('unknown start_of_lease break: %s', repr(text))
            status = CommandResult.Status.ERROR
            code = 'unknown'

        if status is not None:
            result = CommandResult(
                status=status,
                code=code,
            )
            self._set_result(result)
