import logging

from twisted.internet import defer
from twisted.internet.endpoints import TCP6ServerEndpoint

from .protocol import TelematicsFrontendFactory


LOGGER = logging.getLogger(__name__)


class TelematicsFrontendServer(object):

    def run(self):
        raise NotImplementedError

    def handle_command(self, command):
        raise NotImplementedError


class HTTPTelematicsFrontendServer(TelematicsFrontendServer):

    def __init__(self, base_server, reactor, port, timeout):
        self.port = port   # Port number.
        self._port = None  # twisted.internet.tcp.Port instance.
        self._base_server = base_server
        self._reactor = reactor
        self.timeout = timeout
        self.factory = TelematicsFrontendFactory(server=self)

    @defer.inlineCallbacks
    def run(self):
        endpoint = TCP6ServerEndpoint(self._reactor, self.port)
        self._port = yield endpoint.listen(self.factory)
        LOGGER.info('Frontend server is running on port %s', self.port)

    @defer.inlineCallbacks
    def stop(self):
        yield self._port.loseConnection()

    @defer.inlineCallbacks
    def handle_command(self, command):
        self._base_server.send_command(command)
        result = yield command.deferred
        return result


class DummyTelematicsFrontendServer(TelematicsFrontendServer):

    def run(self):
        pass

    def handle_command(self, command):
        pass
