from twisted.test import proto_helpers
from twisted.trial import unittest

from ..backend.protocol import WialonCombineFactory
from ..backend.server import DummyTelematicsBackendServer


class WialonCombineProtocolTestCase(unittest.TestCase):

    def setUp(self):
        factory = WialonCombineFactory(server=DummyTelematicsBackendServer())
        self.proto = factory.buildProtocol(('127.0.0.1', 0))
        self.tr = proto_helpers.StringTransport()
        self.proto.makeConnection(self.tr)

    def _check_reply(self, data, expected_reply):
        self.proto.dataReceived(data)
        self.assertEqual(self.tr.value(), expected_reply)

    def _check_keep_alive(self):
        """Verify that the next packet is handled correctly"""
        self.tr.clear()
        self._check_reply(b'$$\x02\x00\x00', b'@@\x00\x00\x00')

    def test_login(self):
        self._check_reply(
            b'$$\x00\x00\x00\x00\n\x010\x00\x03\x11mK\x02\x17\xcf\x04\x00',
            b'@@\x00\x00\x00',
        )

    def test_data(self):
        self._check_reply(
            b'$$\x01\x00\x01\x00\x9aY\xcf\xd8\xcc\x02\x01\x03S(\xf0\x02;\xc0\x04\x00\x00\x00\xc8\x00\x9f\x10\x00G\x00\x80\x1a\t\x02\x00\x02\xf8\x98\x0b\x00\x01\r\x00\x00\x0e\x00\x00j\x08?5\xc2\x8fm\x00\x10n\x00\nq\x08B|\xba\xccs\x00\x06\x84\xd9\x00\x00\x84\xe2\x08B\x18\x19\x8b\x84\xe4\x08AL\x08\x8d\x84\xe5\x08@\x86g\x9a\x87\xd5\x00\x19\x885\x00\x00\x886\x00\x00\x887\x08C\x0c\xb33\x888\x08\x00\x00\x00\x00\x889\x08\x00\x00\x00\x00\x88:\x08\x00\x00\x00\x00\x88;\x00\x00\x88<\x00&\x88=\x00\x00\x88>\x08B\xb4\x00\x00\x88\x9a\x00\x00\x88\xa2\x00\x00\xdeA',  # pylint: disable=line-too-long
            b'@@\x00\x00\x01',
        )

    def test_batched_data(self):
        batches = [
            b'$$\x01\x00\x01\x05\x8eY\xce0\xd7\x02\x01\x03Rj\xcc\x02=\x90\x1c\x00\x00\x00\x1b\x00\x9f\x12\x00\x00\x00\x80\x01\x88\xac\x00\x00Y\xce0\xda\x02\x01\x03Rj\xcc\x02=\x90\x1c\x00\x00\x00\x1b\x00\xa0\x12\x00\x00\x00\x80\x01\x88\xa7\x00\x01Y\xce0\xdf\x02\x01\x03Rj\xcc\x02=\x90\x1c\x00\x00\x00\x1b\x00\xa0\x12\x00\x00\x00\x80\x01\x88\xa7\x00\x00Y\xce0\xe0\x02\x01\x03Rj\xcc\x02=\x90\x1c\x00\x00\x00\x1b\x00\xa0\x12\x00\x00\x00\x80\x01\x88\xa5\x00\x01Y\xce0\xe1\x02\x01\x03Rj\xcc\x02=\x90\x1c\x00\x00\x00\x1b\x00\xa0\x12\x00\x00\x00\x80\x01\x88\xa6\x00\x01Y\xce0\xe7\x02\x01\x03Rj\xcc\x02=\x90\x1c\x00\x00\x00\x1b\x00\xa0\x12\x00\x00\x00\x80\x01\x88\xa6\x00\x00Y\xce0\xef\x02\x01\x03Rj\xcc\x02=\x90\x1c\x00\x00\x00\x1b\x00\xa1\x11\x00\x00\x00\x80\x01\x88\xa5\x00\x00Y\xce1\x0e\x02\x01\x03Rj\xcc\x02=', # pylint: disable=line-too-long
            b'\x90\x1c\x00\x00\x00\x1b\x00\xa5\x11\x00\x00\x00\x80\x01\x84\xd9\x00\x01Y\xce1\x0e\x02\x01\x03Rj\xcc\x02=\x90\x1c\x00\x00\x00\x1b\x00\xa5\x11\x00\x00\x00\x80\x01\x88\x9a\x00\x01Y\xce1\x0e\x02\x01\x03Rj\xcc\x02=\x90\x1c\x00\x00\x00\x1b\x00\xa5\x11\x00\x00\x00\x80\x01\x88\xa0\x00\x01Y\xce1\x0f\x02\x01\x03Rj\xcc\x02=\x90\x1c\x00\x00\x00\x1b\x00\xa5\x10\x00\x00\x00\x80\x01\x84\xe4\x08A\x12\x01\x06Y\xce1\x10\x02\x01\x03Rj\xcc\x02=\x90\x1c\x00\x00\x00\x1b\x00\xa5\x10\x00\x00\x00\x80\x01\x84\xe4\x08A?\xda1Y\xce1\x10\x02\x01\x03Rj\xcc\x02=\x90\x1c\x00\x00\x00\x1b\x00\xa5\x10\x00\x00\x00\x80\x01\x88\xa3\x00\x01Y\xce1\x14\x02\x01\x03Rj\xcc\x02=\x90\x1c\x00\x00\x00\x1b\x00\xa4\x11\x00\x00\x00\x80\x01\x84\xe4\x08ARK\x0bY\xce1\x17', # pylint: disable=line-too-long
            b'\x02\x01\x03Rj\xcc\x02=\x90\x1c\x00\x00\x00\x1b\x00\xa4\x11\x00\x00\x00\x80\x01\x84\xe4\x08Ae\xbf\xc2Y\xce1\'\x02\x01\x03Rj\xcc\x02=\x90\x1c\x00\x00\x00\x1b\x00\xa4\x10\x00\x00\x00\x80\x01\x88\xa0\x00\x00Y\xce1/\x02\x01\x03Rj\xf0\x02=\x90\x14\x00\x04\x00A\x00\xa1\x11\x00G\x00\x80\x1a\t\x02\x00\x01P\xfb\x0b\x00\x01\r\x00\x00\x0e\x00\x10j\x08?5\xc2\x8fm\x00\x0fn\x00\nq\x08A\xf2\x93\xe8s\x00\x05\x84\xd9\x00\x01\x84\xe2\x08A\xef\xbb\x12\x84\xe4\x08Af\xc3\x9f\x84\xe5\x08@\x82\xa3\xc4\x87\xd5\x00\x1f\x885\x00\x00\x886\x00\x00\x887\x08B\xd8\x00\x00\x888\x08\x00\x00\x00\x00\x889\x08\x00\x00\x00\x00\x88:\x08\x00\x00\x00\x00\x88;\x00\x00\x88<\x00\'\x88=\x01\x047\x88>\x08A@\x00\x00\x88\x9a\x00\x01\x88\xa2\x00\x01Y\xce10\x02\x01\x03Rj\xf8\x02=\x90(\x00\x05\x00/\x00\x9f\x11\x00O\x00\x80\x1a\t\x02\x00\x01P\xfb\x0b\x00\x01\r\x00\x01\x0e\x00\x11j\x08?J=qm\x00\x0fn\x00\nq\x08A\xf2\x96\xe8s\x00\x05\x84\xd9\x00\x01', # pylint: disable=line-too-long
            b'\x84\xe2\x08A\xf2\xba\xb1\x84\xe4\x08Af\xc3\x9f\x84\xe5\x08@\x82\xa3\xc4\x87\xd5\x00\x1f\x885\x00\x00\x886\x00\x00\x887\x08B\xd8\x00\x00\x888\x08\x00\x00\x00\x00\x889\x08\x00\x00\x00\x00\x88:\x08\x00\x00\x00\x00\x88;\x00\x00\x88<\x00\'\x88=\x01\x04r\x88>\x08A@\x00\x00\x88\x9a\x00\x01\x88\xa2\x00\x00Y\xce12\x02\x01\x03Rk\x10\x02=\x90L\x00\x07\x00$\x00\x9e\x10\x00g\x00\x80\x1a\t\x02\x00\x01P\xfd\x0b\x00\x01\r\x00\x01\x0e\x00\x12j\x08?\x83\xd7\nm\x00\x0fn\x00\nq\x08A\xf2\x9e\xbbs\x00\x05\x84\xd9\x00\x01\x84\xe2\x08A\xf2\xba\xb1\x84\xe4\x08Agp\xdd\x84\xe5\x08@\x82\xa3\xc4\x87\xd5\x00\x1f\x885\x00\x00\x886\x00\x00\x887\x08B\xd8\x00\x00\x888\x08\x00\x00\x00\x00\x889\x08\x00\x00\x00\x00\x88:\x08\x00\x00\x00\x00\x88;\x00\x00\x88<\x00\'\x88=\x01\x05\x18\x88>\x08AP\x00\x00\x88\x9a\x00\x01\x88\xa2\x00\x00Y\xce1<\x02\x01\x03Rk\xe4\x02=\x91`\x00\x04\x00.\x00\x9b\x0f\x00x\x00\x80\x1a\t\x02\x00\x01Q\x07\x0b', # pylint: disable=line-too-long
            b'\x00\x01\r\x00\x00\x0e\x00\x13j\x08?\x99\x99\x9am\x00\x0fn\x00\nq\x08A\xf2\xda\x9cs\x00\x05\x84\xd9\x00\x01\x84\xe2\x08A\xf2\xba\xb1\x84\xe4\x08Afm\x00\x84\xe5\x08@\x82\xbe,\x87\xd5\x00\x1f\x885\x00\x00\x886\x00\x00\x887\x08B\xd8\x00\x00\x888\x08\x00\x00\x00\x00\x889\x08\x00\x00\x00\x00\x88:\x08\x00\x00\x00\x00\x88;\x00\x00\x88<\x00\'\x88=\x01\x04"\x88>\x08A\x88\x00\x00\x88\x9a\x00\x01\x88\xa2\x00\x01Y\xce1>\x02\x01\x03Rk\xec\x02=\x91L\x00\x05\x01^\x00\x9c\x0f\x00o\x00\x80\x1a\t\x02\x00\x01Q\t\x0b\x00\x01\r\x00\x01\x0e\x00\x14j\x08?\x8e\x14{m\x00\x0fn\x00\nq\x08A\xf2\xdd\x9cs\x00\x05\x84\xd9\x00\x01\x84\xe2\x08A\xf2\xba\xb1\x84\xe4\x08Ag\x1a>\x84\xe5\x08@\x82\xcb`\x87\xd5\x00\x1f\x885\x00\x00\x886\x00\x00\x887\x08B\xd833\x888\x08\x00\x00\x00\x00\x889\x08\x00\x00\x00\x00\x88:\x08\x00\x00\x00\x00\x88;\x00\x00\x88<\x00\'\x88=\x01\x04L\x88>\x08A\x90\x00\x00\x88\x9a\x00\x01\x88\xa2\x00\x00Y\xce1?', # pylint: disable=line-too-long
            b'\x02\x01\x03Rk\xfc\x02=\x91D',
            b'\x00\x05\x01U\x00\x9b\x0e\x00\x82\x00\x80\x1a\t\x02\x00\x01Q\n\x0b\x00\x01\r\x00\x01\x0e\x00\x15j\x08?\xa6ffm\x00\x0fn\x00\nq\x08A\xf2\xe2\x10s\x00\x05\x84\xd9\x00\x01\x84\xe2\x08A\xf2\xba\xb1\x84\xe4\x08Af\xee\xef\x84\xe5\x08@\x82\xcb`\x87\xd5\x00\x1f\x885\x00\x00\x886\x00\x00\x887\x08B\xd833\x888\x08\x00\x00\x00\x00\x889\x08\x00\x00\x00\x00\x88:\x08\x00\x00\x00\x00\x88;\x00\x00\x88<\x00\'\x88=\x01\x04L\x88>\x08A\x90\x00\x00\x88\x9a\x00\x01\x88\xa2\x00\x00/i' # pylint: disable=line-too-long
        ]
        for batch in batches[:-1]:
            self._check_reply(batch, b'')
        self._check_reply(batches[-1], b'@@\x00\x00\x01')

    def test_keepalive_seq0(self):
        self._check_reply(b'$$\x02\x00\x00', b'@@\x00\x00\x00')

    def test_keepalive_seq1(self):
        self._check_reply(b'$$\x02\x00\x01', b'@@\x00\x00\x01')

    def test_empty(self):
        self._check_reply(b'', b'')
        self._check_keep_alive()

    def test_only_header(self):
        self._check_reply(b'$$', b'')
        self._check_keep_alive()

    def test_invalid_header(self):
        self._check_reply(b'!!\x02\x00\x00', b'')
        self._check_keep_alive()

    def test_driver_message(self):
        self._check_reply(
            b'$$\x01\x00\x02\x00%Zl\xc7\x8a\x01\x0c/DEADBEEF break, engine is on\n\x00\xd4\xb2',
            b'@@\x00\x00\x02'
        )
        self._check_keep_alive()
