# -*- coding: utf-8 -*-

from requests import get
from retry import retry
from datetime import datetime
from json import loads
from .provider import CarState, Provider


class Anytime(Provider):
    BASE_URL = 'https://app.anytimecar.ru/data/v3.9.5'

    APP_VERSION = '1.17.03'

    def load_car_states(self, account):
        url = '{}/{}'.format(self.BASE_URL, 'info/')
        data = self._load_data(account, url)
        timestamp = int(datetime.utcnow().timestamp())
        car_states = []
        for car in data['data']['car_items'].values():
            if 'vehicle_number' in car:
                car['number'] = car['vehicle_number']
            if 'name' in car:
                car['model'] = car['name']
            if 'fuel' in car:
                car['fuel_level'] = car['fuel']
            car_states.append(CarState(
                car_id=str(car['id']),
                timestamp=timestamp,
                region=account.region,
                operator='anytime',
                position=(car['lat'], car['lng']),
                tariffs=[],
                data=car,
            ))
        return car_states

    @retry(tries=3)
    def _load_data(self, account, url):
        headers = {
            'accept': 'application/json',
            'user-agent': 'okhttp/3.11.0',
        }
        response = account._session.get(
            url,
            headers=headers,
        )
        if response.status_code != 200:
            raise Exception()
        return loads(response.content.decode('utf-8'))
