# -*- coding: utf-8 -*-

from requests import get
from retry import retry
from json import loads
from ..helpers import make_animals_session


class Delimobil(object):
    BASE_URL = 'https://api.delitime.ru/api/v1'

    def __init__(self, token=None):
        self._session = make_animals_session()
        self._token = token

    def load_cars(self):
        url = '{}/{}'.format(self.BASE_URL, 'cars?with=fuel,model')
        return self._load_data(url)

    def load_regions(self):
        url = '{}/{}'.format(self.BASE_URL, 'regions')
        return self._load_data(url)

    def load_tariffs(self):
        url = '{}/{}'.format(self.BASE_URL, 'tariff')
        return self._load_data(url)

    @retry(tries=3, delay=1, backoff=2)
    def _load_data(self, url):
        headers = {
            'User-Agent': 'okhttp/3.10.0',
            'Accept-Encoding': 'gzip',
        }
        if self._token:
            headers['Authorization'] = 'Bearer {}'.format(self._token)
        response = self._session.get(url, headers=headers)
        if response.status_code != 200:
            raise Exception()
        data = loads(response.content.decode('utf-8'))
        if not data['success']:
            raise Exception()
        return data
