# -*- coding: utf-8 -*-

from cars.export.yt import Table
from time import time
from ..helpers import make_animals_session, get_region_point


class CarState(object):
    def __init__(
        self, car_id, timestamp, region,
        operator, position, tariffs, data,
    ):
        self.car_id = car_id
        self.timestamp = timestamp
        self.region = region
        self.operator = operator
        self.position = position
        self.tariffs = tariffs
        self.data = data


class Account(object):
    def __init__(
        self, region=None, data=None,
        created=int(time()), updated=int(time())
    ):
        self.region = region
        self.data = data
        self.created = created
        self.updated = updated
        self._session = make_animals_session()
        try:
            self._geopoint = get_region_point(region)
        except RuntimeError:
            pass


class Provider(Table):
    def load_car_states(self, account):
        raise NotImplementedError()

    def _row_to_value(self, row):
        return CarState(
            car_id=row.get('car_id'),
            timestamp=row.get('timestamp'),
            region=row.get('region'),
            operator=row.get('operator'),
            position=row.get('position'),
            tariffs=row.get('tariffs'),
            data=row.get('data'),
        )

    def _value_to_row(self, value):
        return {
            'car_id': value.car_id,
            'timestamp': value.timestamp,
            'region': value.region,
            'operator': value.operator,
            'position': value.position,
            'tariffs': value.tariffs,
            'data': value.data,
        }

    def _get_schema(self):
        return [
            {'name': 'car_id',    'type': 'string'},
            {'name': 'timestamp', 'type': 'int64' },
            {'name': 'region',    'type': 'string'},
            {'name': 'operator',  'type': 'string'},
            {'name': 'position',  'type': 'any'   },
            {'name': 'tariffs',   'type': 'any'   },
            {'name': 'data',      'type': 'any'   },
        ]
