# -*- coding: utf-8 -*-

from requests import get
from retry import retry
from datetime import datetime
from json import loads
from random import choice
from jwt import encode
from uuid import uuid4
from .provider import CarState, Provider
from ..helpers import make_animals_session


class Urbi(Provider):
    BASE_URL = 'https://apiv2.urbi.co'

    SECRET = 'oiWz9Y1F2XKhsTn29e4xOzbrZ6iYYUpXIAkknMZw3VukfmYSJvssjdecy0NpfyqzG6oB4k8PdkWfpIWcfbqkd8bx020iKgTalsHGXQRdIsgCIXGdaJpqaA46df0yWF1V'

    def load_car_states(self, account):
        region, operator = account.region.split(':')
        url = '{}/location/{}/vehicle/{}'.format(
            self.BASE_URL, region, operator,
        )
        data = self._get_data(account, url)
        timestamp = int(datetime.utcnow().timestamp())
        car_states = []
        for car in data['vehicles']:
            if car is None:
                continue
            if 'id' not in car or not car['id']:
                continue
            car_id = str(car['id'])
            position = (car['location']['lat'], car['location']['lon'])
            tariff = car['prices']
            del car['id']
            del car['location']
            del car['prices']
            car_states.append(CarState(
                car_id=car_id,
                timestamp=timestamp,
                region=region,
                operator=operator,
                position=position,
                tariffs=[tariff],
                data=car,
            ))
        return car_states

    def _get_data(self, account, url):
        response = account._session.get(
            url,
            headers={
                'Cache-Control': 'max-age=640000',
                'Accept-Encoding': 'gzip',
                'User-Agent': 'okhttp/3.8.0',
            },
            params={
                'jwt': self._get_jwt(account.data),
            },
            timeout=10,
        )
        if response.status_code != 200:
            raise Exception()
        return loads(response.content.decode('utf-8'))

    def _gen_iddb(self):
        return ''.join(choice('abcdef0123456789') for _ in range(16))

    def _get_jwt(self, data):
        data = {
            'payload': {
                'cityName': data['city'],
                'providerName': data['operator'],
            },
            'info': {
                'app': 'urbi',
                'b': '327',
                'hl': 'en',
                'platform': 'android',
                'vid': data['device']['id'],
                'location': {
                    'idDb': self._gen_iddb(),
                    'latLng': {
                        'latitude': data['latitude'],
                        'longitude': data['longitude'],
                    },
                    'lat': data['latitude'],
                    'lon': data['longitude'],
                },
                'model': data['device'],
            },
        }
        return encode(data, self.SECRET, algorithm='HS256').decode()
