from django.contrib import admin
from django.contrib.auth.admin import GroupAdmin
from django.contrib.auth.models import Group, Permission

from cars.admin.models.permissions import AdminPermissions


class CarsharingGroupAdmin(GroupAdmin):

    def has_add_permission(self, request):
        return request.user.is_superuser

    def has_delete_permission(self, request, obj=None):
        return request.user.is_superuser

    def formfield_for_manytomany(self, db_field, request, **kwargs):  # pylint: disable=signature-differs
        if db_field.name == 'permissions':
            kwargs['queryset'] = (
                Permission.objects
                .filter(
                    content_type__model=AdminPermissions._meta.model_name,
                )
                .exclude(
                    name__startswith='Can ',
                )
            )
        return super().formfield_for_manytomany(db_field, request, **kwargs)


admin.site.unregister(Group)
admin.site.register(Group, CarsharingGroupAdmin)
