import logging

from .documents_textdata_converter import (
    UserDrivingLicenseSmartIDConverter,
    UserDrivingLicensePDF417Converter,
    UserPassportSmartIDConverter,
)


LOGGER = logging.getLogger(__name__)


class RecognizedDataSubmitter:

    def __init__(self, datasync_client):
        self._datasync_client = datasync_client

    def submit_recognized_driver_license(self, uid, front, back):
        data = {
            'front': front,
            'back': back,
        }

        license_text_data = {}

        try:
            # Even if this recognizer fail, we should be able to run another one
            license_text_data = UserDrivingLicenseSmartIDConverter().convert(data)
        except Exception:
            LOGGER.exception('Recognizing driving license with SmartID failed')

        try:
            # Even if PDF417 fail, we should be able to send what he can possibly have from
            # the first recognizer
            license_text_data.update(
                UserDrivingLicensePDF417Converter().convert(data)
            )
        except Exception:
            LOGGER.exception('Recognizing driving license with PDF417 failed')

        self._datasync_client.update_license_unverified(uid, 'initial', license_text_data)

    def submit_recognized_passport(self, uid, biographical, registration):
        data = {
            'biographical': biographical,
            'registration': registration,
        }

        passport_text_data = UserPassportSmartIDConverter().convert(data)

        self._datasync_client.update_passport_unverified(uid, 'initial', passport_text_data)
