import copy
import logging
import os

import kubiki

import cars.settings
from cars.core.daemons import CarsharingDaemon
from cars.core.util import make_yt_client
from ..models import User
from ..serializers import AppInstallSerializer


LOGGER = logging.getLogger(__name__)


class YtFastExportDaemon(CarsharingDaemon):

    tick_interval = '* * * * *'  # every 5 mins, but less data

    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        self._yt = make_yt_client('data')

    def get_distributed_lock_relative_path(self):
        return 'users/locks/users_yt_fast_export.lock'

    def get_solomon_sensor_prefix(self):
        return 'users.yt_fast_export'

    def get_solomon_service(self):
        return 'users'

    def get_distributed_lock(self):
        locks_config = copy.deepcopy(cars.settings.YT['locks'])
        base_dir = locks_config.pop('base_dir')
        locks_config['path'] = os.path.join(base_dir, self.get_distributed_lock_relative_path())

        locks_config['ttl'] = 180  # avoid loss of the lock, like in bigger export

        return kubiki.distributed_lock.YtLock(**locks_config)

    def _users_table_rows(self):
        all_users = (
            User.objects
            .only(
                'id',
                'status',
            )
        )

        for user in all_users:
            result = {
                'id': str(user.id),
                'status': user.status,
            }
            yield result

    def _do_tick(self):
        with self._yt.Transaction(timeout=50 * 60 * 1000, ping_ancestor_transactions=True):
            self._yt.write_table(
                cars.settings.USERS['fast_export_table'],
                self._users_table_rows(),
            )
