import datetime
from uuid import uuid4

import pytz
from factory import LazyFunction
from factory.django import DjangoModelFactory
from factory.fuzzy import FuzzyDateTime

from cars.core.constants import AppPlatform
from ..models.app_install import AppInstall


class AppInstallFactory(DjangoModelFactory):

    class Meta:
        model = AppInstall

    is_latest = True
    uuid = LazyFunction(uuid4)
    device_id = LazyFunction(uuid4)
    platform = AppPlatform.ANDROID.value
    app_version = '777'
    app_build = '777'
    created_at = FuzzyDateTime(datetime.datetime(2017, 1, 1, tzinfo=pytz.UTC))
    refreshed_at = FuzzyDateTime(datetime.datetime(2017, 1, 1, tzinfo=pytz.UTC))
