from factory import post_generation, RelatedFactory, Sequence
from factory.django import DjangoModelFactory
from factory.fuzzy import FuzzyText

from cars.django.factories import FuzzyPhoneNumber
from cars.orders.core.user_tags import OrdersUserTags
from ..models.user import User
from .app_install import AppInstallFactory
from .user_credit_card import UserCreditCardFactory


class UserFactory(DjangoModelFactory):

    class Meta:
        model = User

    uid = Sequence(lambda n: n)

    phone = FuzzyPhoneNumber()
    is_phone_verified = True
    email = Sequence('factory{}@yandex.ru'.format)
    first_name = FuzzyText()
    last_name = FuzzyText()
    status = User.Status.ACTIVE.value
    credit_card = RelatedFactory(UserCreditCardFactory, 'user')
    tags = [
        OrdersUserTags.NO_PRELIMINARY_PAYMENTS.value,
    ]

    @post_generation
    def app_installs(self, create, extracted, **kwargs):  # pylint: disable=unused-argument
        if not create:
            # Simple build, do nothing.
            return

        if extracted:
            for app_install in extracted:
                self.app_installs.add(app_install)  # pylint: disable=no-member
        else:
            AppInstallFactory.create(user=self)

    @classmethod
    def _setup_next_sequence(cls):
        latest_user = User.objects.order_by('-uid').first()
        return latest_user.uid + 1 if latest_user else 1
