import datetime

import pytz
from factory.django import DjangoModelFactory
from factory.fuzzy import FuzzyDateTime, FuzzyText

from ..models.user_credit_card import UserCreditCard


class UserCreditCardFactory(DjangoModelFactory):

    class Meta:
        model = UserCreditCard

    paymethod_id = FuzzyText()
    pan_prefix = FuzzyText(length=6)
    pan_suffix = FuzzyText(length=4)
    bound_at = FuzzyDateTime(datetime.datetime(2017, 1, 1, tzinfo=pytz.UTC))
