import datetime

from django.utils import timezone
from factory import SubFactory
from factory.django import DjangoModelFactory
from factory.fuzzy import FuzzyDateTime

from ..models.user_documents import UserDocument, UserDocumentBackgroundVideo, UserDocumentPhoto
from .user import UserFactory


class UserDocumentFactory(DjangoModelFactory):

    class Meta:
        model = UserDocument

    type = UserDocument.Type.DRIVER_LICENSE.value
    submitted_at = FuzzyDateTime(timezone.make_aware(datetime.datetime(2017, 1, 1)))
    user = SubFactory(UserFactory)


class UserDocumentPhotoFactory(DjangoModelFactory):

    class Meta:
        model = UserDocumentPhoto

    document = SubFactory(UserDocumentFactory)
    type = UserDocumentPhoto.Type.DRIVER_LICENSE_FRONT.value
    submitted_at = FuzzyDateTime(timezone.make_aware(datetime.datetime(2017, 1, 1)))


class UserDocumentBackgroundVideoFactory(DjangoModelFactory):

    class Meta:
        model = UserDocumentBackgroundVideo

    photo = SubFactory(UserDocumentPhotoFactory)
    mime_type = 'video/mp4'
    submitted_at = FuzzyDateTime(timezone.make_aware(datetime.datetime(2017, 1, 1)))
