import django.db
import psycopg2

import django_yauth.middleware


class ForceEvaluateUserMixin(object):

    def process_request(self, request):
        response = super().process_request(request)

        db_exceptions = (
            django.db.DatabaseError,
            django.db.OperationalError,
            psycopg2.DatabaseError,
            psycopg2.OperationalError,
        )

        # Force evaluate lazy property.
        try:
            request.user  # pylint: disable=pointless-statement
        except db_exceptions:
            # Retry PgBouncer connection errors.
            django.db.close_old_connections()
            request.user  # pylint: disable=pointless-statement

        return response


class YandexAuthenticationMiddleware(ForceEvaluateUserMixin,
                                     django_yauth.middleware.YandexAuthMiddleware):
    pass


class TestYandexAuthenticationMiddleware(ForceEvaluateUserMixin,
                                         django_yauth.middleware.YandexAuthTestMiddleware):
    pass
