# -*- coding: utf-8 -*-
# Generated by Django 1.11.6 on 2017-11-01 23:06
from __future__ import unicode_literals

from django.conf import settings
import django.contrib.auth.models
import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import phonenumber_field.modelfields
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0008_alter_user_username_max_length'),
    ]

    operations = [
        migrations.CreateModel(
            name='User',
            fields=[
                ('password', models.CharField(max_length=128, verbose_name='password')),
                ('last_login', models.DateTimeField(blank=True, null=True, verbose_name='last login')),
                ('is_superuser', models.BooleanField(default=False, help_text='Designates that this user has all permissions without explicitly assigning them.', verbose_name='superuser status')),
                ('first_name', models.CharField(blank=True, max_length=30, verbose_name='first name')),
                ('last_name', models.CharField(blank=True, max_length=30, verbose_name='last name')),
                ('email', models.EmailField(blank=True, max_length=254, verbose_name='email address')),
                ('is_staff', models.BooleanField(default=False, help_text='Designates whether the user can log into this admin site.', verbose_name='staff status')),
                ('is_active', models.BooleanField(default=True, help_text='Designates whether this user should be treated as active. Unselect this instead of deleting accounts.', verbose_name='active')),
                ('date_joined', models.DateTimeField(default=django.utils.timezone.now, verbose_name='date joined')),
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('uid', models.BigIntegerField(unique=True)),
                ('username', models.CharField(blank=True, max_length=64)),
                ('patronymic_name', models.CharField(blank=True, max_length=64)),
                ('phone', phonenumber_field.modelfields.PhoneNumberField(max_length=128, null=True, unique=True)),
                ('status', models.CharField(choices=[('active', 'ACTIVE'), ('onboarding', 'ONBOARDING')], max_length=16)),
                ('groups', models.ManyToManyField(blank=True, help_text='The groups this user belongs to. A user will get all permissions granted to each of their groups.', related_name='user_set', related_query_name='user', to='auth.Group', verbose_name='groups')),
                ('user_permissions', models.ManyToManyField(blank=True, help_text='Specific permissions for this user.', related_name='user_set', related_query_name='user', to='auth.Permission', verbose_name='user permissions')),
            ],
            options={
                'db_table': 'user',
            },
            managers=[
                ('objects', django.contrib.auth.models.UserManager()),
            ],
        ),
        migrations.CreateModel(
            name='UserCreditCard',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('pan_prefix', models.CharField(max_length=6)),
                ('pan_suffix', models.CharField(max_length=4)),
                ('bound_at', models.DateTimeField()),
                ('user', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='credit_card', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'user_credit_card',
            },
        ),
        migrations.CreateModel(
            name='UserDrivingLicense',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('submitted_at', models.DateTimeField()),
                ('verified_at', models.DateTimeField(blank=True, null=True)),
                ('datasync_id', models.IntegerField(blank=True, null=True, unique=True)),
                ('front_recognized', django.contrib.postgres.fields.jsonb.JSONField(blank=True, null=True)),
                ('s3_back_id', models.IntegerField(blank=True, null=True, unique=True)),
                ('s3_front_id', models.IntegerField(blank=True, null=True, unique=True)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'user_driving_license',
            },
        ),
        migrations.CreateModel(
            name='UserPassport',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('submitted_at', models.DateTimeField()),
                ('verified_at', models.DateTimeField(blank=True, null=True)),
                ('datasync_id', models.IntegerField(blank=True, null=True, unique=True)),
                ('selfie_recognized', django.contrib.postgres.fields.jsonb.JSONField(blank=True, null=True)),
                ('s3_registration_id', models.IntegerField(blank=True, null=True, unique=True)),
                ('s3_selfie_id', models.IntegerField(blank=True, null=True, unique=True)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'user_passport',
            },
        ),
        migrations.CreateModel(
            name='UserPhoneBinding',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('phone', models.CharField(max_length=16, null=True)),
                ('track_id', models.CharField(max_length=64, unique=True)),
                ('submit_date', models.DateTimeField()),
                ('commit_date', models.DateTimeField(null=True)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'user_phone_binding',
            },
        ),
    ]
