# -*- coding: utf-8 -*-
# Generated by Django 1.11.6 on 2017-11-06 17:12
from __future__ import unicode_literals

from django.conf import settings
import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    dependencies = [
        ('users', '0002_default_user_status'),
    ]

    operations = [
        migrations.CreateModel(
            name='UserDocument',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('natural_id_fingerprint', models.CharField(blank=True, max_length=64, null=True, unique=True)),
                ('type', models.CharField(choices=[('dl', 'DRIVER_LICENSE'), ('p', 'PASSPORT')], max_length=2)),
                ('submitted_at', models.DateTimeField()),
                ('verified_at', models.DateTimeField(blank=True, null=True)),
                ('datasync_id', models.CharField(blank=True, max_length=32, null=True, unique=True)),
                ('unverified_datasync_id', models.CharField(blank=True, max_length=32, null=True, unique=True)),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='documents', to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'user_document',
            },
        ),
        migrations.CreateModel(
            name='UserDocumentBackgroundVideo',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('submitted_at', models.DateTimeField()),
            ],
            options={
                'db_table': 'user_document_background_video',
            },
        ),
        migrations.CreateModel(
            name='UserDocumentPhoto',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('type', models.CharField(choices=[('lf', 'DRIVER_LICENSE_FRONT'), ('lb', 'DRIVER_LICENSE_BACK'), ('pb', 'PASSPORT_BIOGRAPHICAL'), ('pr', 'PASSPORT_REGISTRATION'), ('ps', 'PASSPORT_SELFIE')], max_length=2)),
                ('recognized_meta', django.contrib.postgres.fields.jsonb.JSONField(blank=True, null=True)),
                ('submitted_at', models.DateTimeField()),
                ('verified_at', models.DateTimeField(blank=True, null=True)),
                ('document', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='photos', to='users.UserDocument')),
            ],
            options={
                'db_table': 'user_document_photo',
            },
        ),
        migrations.RemoveField(
            model_name='userdrivinglicense',
            name='user',
        ),
        migrations.RemoveField(
            model_name='userpassport',
            name='user',
        ),
        migrations.DeleteModel(
            name='UserDrivingLicense',
        ),
        migrations.DeleteModel(
            name='UserPassport',
        ),
        migrations.AddField(
            model_name='userdocumentbackgroundvideo',
            name='photo',
            field=models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='background_video', to='users.UserDocumentPhoto'),
        ),
    ]
