# -*- coding: utf-8 -*-
# Generated by Django 1.11.6 on 2017-11-18 19:01
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    dependencies = [
        ('users', '0005_add_user_document_background_video_mime_type'),
    ]

    operations = [
        migrations.CreateModel(
            name='AppInstall',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, primary_key=True, serialize=False)),
                ('uuid', models.UUIDField()),
                ('device_id', models.UUIDField()),
                ('platform', models.CharField(choices=[('a', 'ANDROID'), ('i', 'IOS')], max_length=1)),
                ('push_token', models.TextField(blank=True, null=True)),
                ('is_latest', models.BooleanField()),
                ('created_at', models.DateTimeField()),
                ('refreshed_at', models.DateTimeField()),
                ('user', models.ForeignKey(db_index=False, on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'db_table': 'app_install',
            },
        ),
        migrations.AddIndex(
            model_name='appinstall',
            index=models.Index(fields=['user_id'], name='app_install_user_id_idx'),
        ),
        migrations.AddIndex(
            model_name='appinstall',
            index=models.Index(fields=['uuid'], name='app_install_uuid_idx'),
        ),
        migrations.AddIndex(
            model_name='appinstall',
            index=models.Index(fields=['device_id'], name='app_install_device_id_idx'),
        ),
    ]
