# -*- coding: utf-8 -*-
# Generated by Django 1.11.6 on 2017-12-06 18:24
# pylint: disable=line-too-long
from __future__ import unicode_literals

from django.db import migrations
from django.contrib.postgres.operations import TrigramExtension


class Migration(migrations.Migration):

    dependencies = [
        ('users', '0008_user_document_natural_id_fingerprint_nonunique'),
    ]

    operations = [
        # Fulltext lookups in admin.
        TrigramExtension(),
        migrations.RunSQL(
            sql="CREATE INDEX user_first_name_gin_trgm_idx ON public.user USING GIN (first_name gin_trgm_ops)",
            reverse_sql="DROP INDEX user_first_name_gin_trgm_idx",
        ),
        migrations.RunSQL(
            sql="CREATE INDEX user_last_name_gin_trgm_idx ON public.user USING GIN (last_name gin_trgm_ops)",
            reverse_sql="DROP INDEX user_last_name_gin_trgm_idx",
        ),
        migrations.RunSQL(
            sql="CREATE INDEX user_patronymic_name_gin_trgm_idx ON public.user USING GIN (patronymic_name gin_trgm_ops)",
            reverse_sql="DROP INDEX user_patronymic_name_gin_trgm_idx",
        ),
        migrations.RunSQL(
            sql="CREATE INDEX user_email_gin_trgm_idx ON public.user USING GIN (email gin_trgm_ops)",
            reverse_sql="DROP INDEX user_email_gin_trgm_idx",
        ),
        migrations.RunSQL(
            sql="CREATE INDEX user_phone_gin_trgm_idx ON public.user USING GIN (phone gin_trgm_ops)",
            reverse_sql="DROP INDEX user_phone_gin_trgm_idx",
        ),
        migrations.RunSQL(
            sql="CREATE INDEX user_username_gin_trgm_idx ON public.user USING GIN (username gin_trgm_ops)",
            reverse_sql="DROP INDEX user_username_gin_trgm_idx",
        ),
    ]
