from django.contrib.postgres.fields.jsonb import JSONField
from django.db import models


class UserDevices(models.Model):
    user_id = models.UUIDField()
    device_id = models.TextField(primary_key=True)

    token = models.TextField(null=True)
    verified = models.BooleanField()
    enabled = models.BooleanField()
    description = JSONField()

    class Meta:
        db_table = 'user_devices'
        unique_together = ['user_id', 'device_id']
        managed = False

    def __str__(self):
        return str('{}:{}'.format(self.user_id, self.device_id))
