import uuid

from django.db import models

from .user import User


class UserPhoneBinding(models.Model):
    id = models.UUIDField(default=uuid.uuid4, primary_key=True)
    user = models.ForeignKey(
        User,
        on_delete=models.CASCADE,
        related_name='phone_bindings',
    )
    phone = models.CharField(max_length=16, null=True)
    track_id = models.CharField(max_length=64, unique=True)
    submit_date = models.DateTimeField()
    commit_date = models.DateTimeField(null=True)

    class Meta:
        db_table = 'user_phone_binding'

    def __str__(self):
        return (
            '{}: {}'.format(
                self.submit_date.isoformat(),
                self.phone if self.phone else None,
            )
        )
