import uuid

from django.conf import settings
from django.db import models


class RegistrationState(models.Model):

    id = models.UUIDField(default=uuid.uuid4, primary_key=True)

    user = models.OneToOneField(
        settings.AUTH_USER_MODEL,
        on_delete=models.CASCADE,
        related_name='registration_state',
    )

    chat_started_at = models.DateTimeField(null=True)
    chat_completed_at = models.DateTimeField(null=True)
    chat_action_id = models.CharField(max_length=32, null=True)

    total_taxi_cashback = models.DecimalField(max_digits=9, decimal_places=2, default=0)

    outcome_notification_sent_at = models.DateTimeField(null=True)
    update_app_notification_sent_at = models.DateTimeField(null=True)

    # https://st.yandex-team.ru/EDIT-27102
    email1_sent_at = models.DateTimeField(null=True)
    email2_sent_at = models.DateTimeField(null=True)
    email3_sent_at = models.DateTimeField(null=True)
    email4_sent_at = models.DateTimeField(null=True)
    email5_sent_at = models.DateTimeField(null=True)
    email6_sent_at = models.DateTimeField(null=True)
    email7_sent_at = models.DateTimeField(null=True)
    email8_sent_at = models.DateTimeField(null=True)

    class Meta:
        db_table = 'user_registration_state'
