from django.db import models

from phonenumber_field.modelfields import PhoneNumberField


class UserDataHistory(models.Model):
    history_event_id = models.AutoField(primary_key=True)
    history_user_id = models.CharField(max_length=36)
    history_action = models.TextField()
    history_timestamp = models.IntegerField()
    history_comment = models.TextField(blank=True, null=True)
    history_originator_id = models.TextField(blank=True, null=True)

    password = models.CharField(max_length=128, null=True)
    last_login = models.DateTimeField(null=True)
    is_superuser = models.NullBooleanField()

    first_name = models.CharField(max_length=30, blank=True, null=True)
    last_name = models.CharField(max_length=150, blank=True, null=True)
    email = models.EmailField(max_length=128, blank=True, null=True)
    is_staff = models.NullBooleanField()
    is_active = models.NullBooleanField()
    date_joined = models.DateTimeField(null=True)

    id = models.UUIDField(null=True)
    uid = models.BigIntegerField(null=True)
    username = models.CharField(max_length=64, blank=True, null=True)
    patronymic_name = models.CharField(max_length=64, blank=True, null=True)
    phone = PhoneNumberField(null=True)
    status = models.CharField(max_length=16, null=True)
    registered_at = models.DateTimeField(null=True)
    is_yandexoid = models.NullBooleanField()

    tags = models.CharField(max_length=128, null=True)  # inconsistent
    is_phone_verified = models.NullBooleanField()
    is_email_verified = models.NullBooleanField()
    is_plus_user = models.NullBooleanField()
    is_plus_screen_viewed = models.NullBooleanField()

    introscreens_id = models.UUIDField(null=True)
    updated_at = models.IntegerField(null=True)

    persdata_consents_id = models.UUIDField(null=True)

    old_backend_debt = models.DecimalField(max_digits=9, decimal_places=2, null=True)

    passport_number_hash = models.CharField(max_length=64, null=True)
    driving_license_number_hash = models.CharField(max_length=64, null=True)

    is_first_riding = models.NullBooleanField(default=True, null=True)

    passport_ds_revision = models.CharField(max_length=64, null=True)
    driving_license_ds_revision = models.CharField(max_length=64, null=True)

    registration_geo = models.CharField(max_length=16, null=True)
    has_at_mark = models.NullBooleanField()

    class Meta:
        db_table = 'drive_user_data_history'
        managed = False
