# -*- coding: utf-8 -*-

from django.db import models

from cars.carsharing.models import DriveRole
from .user import User


class UserRole(models.Model):
    user = models.ForeignKey(
        User,
        on_delete=models.CASCADE,
        related_name='roles',
        primary_key=True,
    )
    role = models.ForeignKey(
        DriveRole,
        on_delete=models.CASCADE,
        related_name='user_roles_role',
    )
    deadline = models.BigIntegerField()
    data = models.TextField()
    active = models.BooleanField()

    class Meta:
        managed = False
        db_table = 'user_roles'


class UserRolesHistory(models.Model):
    history_event_id = models.IntegerField(primary_key=True)
    history_timestamp = models.BigIntegerField()
    user = models.ForeignKey(
        User,
        on_delete=models.CASCADE,
        related_name='roles_history',
    )

    class Meta:
        managed = False
        db_table = 'user_roles_history'
