import uuid

from django.db import models

from .user import User


class UserTag(models.Model):
    tag_id = models.UUIDField(
        null=False,
        default=uuid.uuid4,
        primary_key=True
    )

    object = models.ForeignKey(
        User,
        on_delete=models.CASCADE,
    )

    tag = models.CharField(max_length=50, null=True)
    data = models.TextField(null=True)

    user_id = models.CharField(max_length=50, null=True)
    performer = models.CharField(max_length=50, null=True)

    priority = models.IntegerField(null=True, default=0)
    ts = models.IntegerField(null=True, default=0)

    active_since = models.IntegerField(null=True)
    deadline = models.IntegerField(null=True, default=0)

    snapshot = models.TextField(null=True)

    class Meta:
        managed = False
        db_table = 'user_tags'

        indexes = [
            models.Index(
                fields=['object_id'],
                name='user_tags_object_id_index',
            ),
            models.Index(
                fields=['tag'],
                name='user_tags_tag_index',
            ),
        ]


class UserTagHistory(models.Model):
    history_event_id = models.AutoField(null=False, primary_key=True)

    history_user_id = models.TextField(null=False)

    history_timestamp = models.IntegerField(null=False)

    history_comment = models.TextField(null=True)

    history_action = models.TextField(null=False)

    history_originator_id = models.TextField(null=True)

    object = models.ForeignKey(
        User,
        on_delete=models.CASCADE,
        null=False
    )

    tag = models.TextField(null=True)
    tag_id = models.UUIDField(null=True)

    data = models.TextField(null=True)

    performer = models.TextField(null=True)

    priority = models.IntegerField(null=True, default=0)

    snapshot = models.TextField(null=True)

    class Meta:
        managed = False
        db_table = 'user_tags_history'

        indexes = [
            models.Index(
                fields=['object_id'],
                name='user_tags_object_id_index',
            ),
            models.Index(
                fields=['tag'],
                name='user_tags_tag_index',
            ),
        ]
