from rest_framework.serializers import ModelSerializer

from ..models import UserCreditCard


class UserCreditCardSerializer(ModelSerializer):

    class Meta:
        model = UserCreditCard
        fields = '__all__'

    def to_representation(self, obj):
        return {
            'pan': {
                'prefix': obj.pan_prefix,
                'suffix': obj.pan_suffix,
                'masked': obj.get_masked_pan(),
            },
        }
