from rest_framework.serializers import ModelSerializer, SerializerMethodField

from cars.django.serializers import BaseSerializer
from ..models import UserDocumentPhoto


class UserDriverLicenseSerializer(BaseSerializer):

    back_photos = SerializerMethodField()

    def get_back_photos(self, obj):
        back_photos = [
            p
            for p in obj.user.document_photos.all()
            if p.type == UserDocumentPhoto.Type.DRIVER_LICENSE_BACK.value
        ]
        return [str(p.id) for p in back_photos]
